unit Pens_U;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data;

type
  TWinForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    Button1: System.Windows.Forms.Button;
    Button2: System.Windows.Forms.Button;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure Button1_Click(sender: System.Object; e: System.EventArgs);
    procedure Button2_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    { Private Declarations }
  public
    constructor Create;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TWinForm))]

implementation

uses System.Drawing.Drawing2D;

{$AUTOBOX ON}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinForm.InitializeComponent;
begin
  Self.Button1 := System.Windows.Forms.Button.Create;
  Self.Button2 := System.Windows.Forms.Button.Create;
  Self.SuspendLayout;
  // 
  // Button1
  // 
  Self.Button1.Location := System.Drawing.Point.Create(24, 16);
  Self.Button1.Name := 'Button1';
  Self.Button1.TabIndex := 0;
  Self.Button1.Text := 'Draw Curve';
  Include(Self.Button1.Click, Self.Button1_Click);
  // 
  // Button2
  // 
  Self.Button2.Location := System.Drawing.Point.Create(128, 16);
  Self.Button2.Name := 'Button2';
  Self.Button2.TabIndex := 1;
  Self.Button2.Text := 'Texture';
  Include(Self.Button2.Click, Self.Button2_Click);
  // 
  // TWinForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(496, 446);
  Self.Controls.Add(Self.Button2);
  Self.Controls.Add(Self.Button1);
  Self.Name := 'TWinForm';
  Self.Text := 'WinForm';
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TWinForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;


// You use a pen to draw lines and curves. You can set properties, such as
// PenType, DashStyle, Width, Color, and EndCap to control how a Pen draws.
procedure TWinForm.Button1_Click(sender: System.Object; e: System.EventArgs);
var
  g: Graphics;
  p: Pen;
  points: array[0..6] of Point;
begin
  g:= CreateGraphics;

  //Create a pen 20 pixels wide that is and purple and partially transparent.
  p:= Pen.Create(Color.FromArgb(150, Color.Goldenrod), 26);

  //Make it a dashed pen.
  p.DashStyle:= DashStyle.Solid;
  //Make the ends round.
  p.StartCap:= LineCap.Round;
  p.EndCap:= LineCap.Round;

  // Create the path of the curve with an array of points.
  points[0]:= Point.Create(60, 50);
  points[1]:= Point.Create(270, 90);
  points[2]:= Point.Create(140, 130);
  points[3]:= Point.Create(180, 230);
  points[4]:= Point.Create(240, 120);
  points[5]:= Point.Create(360, 420);
  points[6]:= Point.Create(360, 270);

  //Now draw a curve using the pen.
  g.DrawCurve(p, points);
end;

// It is also possible to use a texture as the fill for a pen by using a textured brush.
procedure TWinForm.Button2_Click(sender: System.Object; e: System.EventArgs);
var
  g: Graphics;
  b: TextureBrush;
  p: Pen;
  points: array[0..4] of Point;
begin
  g:= CreateGraphics;
  b:= TextureBrush.Create(Bitmap.Create('Greenstone.bmp'));
  p:= Pen.Create(b, 16);
  p.DashStyle:= DashStyle.Dash;
  p.StartCap:= LineCap.Triangle;
  p.EndCap:= LineCap.Round;
  points[0]:= Point.Create(60, 50);
  points[1]:= Point.Create(270, 90);
  points[2]:= Point.Create(140, 130);
  points[3]:= Point.Create(180, 230);
  points[4]:= Point.Create(220, 120);
  g.DrawCurve(p, points);
end;

end.
